unit LeastSquares01;

interface
  uses SysUtils, Dialogs, Gauss01, Math, GraphXYv50, MainData, Report01;

// ==============================================================
//    .
// ==============================================================

  //   
  Type  TabFuncType = TGraphArr;
  Type  ptTabFuncType = ^TabFuncType;


  //    
  Type TAproxCB = record
     // :        ( )
     ptTabFun : ptTabFuncType;  //     
     RqExp    : byte;           //    . 
     // :      (   )
     Abend    : byte;           //    (0 - )
     ApCod    : byte;           //     (0 -   )
     ApMsg    : string;         //    
     ApExp    : byte;           //    . 
     ApAi     : array of extended;  // . . : A0, A1, ... An
  end; // Type TAproxCB

// ==============================================================
//    
// ==============================================================
//--------------------------------------------------------------
//    X   RqExp
function Involve(X : extended; RqExp : byte) : extended;
//--------------------------------------------------------------
//       AI   X
function CalcPolinom (RqSeries : word;
                      RqAI     : array of extended;
                      RqX      : extended) : extended;
//--------------------------------------------------------------
//       BasisSelectList,
//    AI   X
function BasisCalcPolinom (RqSelectKoeff : boolean;
                           RqSeries      : word;
                           RqAI          : array of extended;
                           RqX           : extended) : extended;
//--------------------------------------------------------------
//      
procedure RunApprox01 (RqSeries : word; var AproxCB : TAproxCB);

// ==============================================================
//                     .
// ==============================================================
implementation

  //        
  var Matrix01 : TGaussEquationsSet;

// ==============================================================
//  .
// ==============================================================
// --------------------------------------------------------------
// 29.10.2008
//   
function ReFuncArgument(RqSeries : word; X : extended) : extended;
begin
  ReFuncArgument := 0; //    
  try
     case RqSeries of
       cfPolinomX : begin
          //       
          ReFuncArgument := X;
       end;
       cfPolinom1DX  : begin  // 
         //       1/
         //    extended = (+/-) 1.7E308;
         if Abs(X) > 1.0E-300
         then ReFuncArgument := 1/X
         else ReFuncArgument := 1.0E300; //  8 
       end;
       cfPolinomExpX  : begin  // 
         //       EXP()
         if Abs(Exp(X)) > 1.0E300
         then ReFuncArgument := 1.0E300
         else ReFuncArgument := Exp(X);
       end;
       cfPolinomLnX  : begin  // 
         //       Ln()
         //    extended = (+/-) 1.7E308;
         if X > 1.0E-300
         then ReFuncArgument := Ln(X)
         else ReFuncArgument := Ln(1.0E-300); //  7 
       end;

     end; // of case RqSeries
  except
  end;
end; // of function

// --------------------------------------------------------------
// 11.10.2008
//    X   RqExp
function Involve(X : extended; RqExp : byte) : extended;
var Prod : Extended;
    WExp : byte;
begin
  WExp := 1;        //        X
  Prod := 1;        //    
  while (WExp <= RqExp) do
  begin
     Prod := X * Prod;
     Inc(WExp);
  end;
  //      
  // -------------------------------
  //   Extended  extended
  // extended	  5.0E-324 ... 1.7E308
  // Extended	3.6E-4951 .. 1.1E4932
  //--------------------------------
  //    8 
  if Abs(Prod) > 1.0E300
  then begin
     if Prod > 0
     then  Involve :=  1.0E300
     else  Involve := -1.0E300
  end
  else Involve := Prod;
  //--------------------------------
  if Abs(Prod) < 1.0E-300
  then Involve := 0;
  //--------------------------------
end; // of function

// --------------------------------------------------------------
//  03.10.2008
//       AI   X
function CalcPolinom (RqSeries : word;
                      RqAI     : array of extended;
                      RqX      : extended) : extended;
var Ind  : integer;
    WPol : extended;
begin
 WPol := 0;
 if Length(RqAI) > 0 then
 begin
   for Ind := Low(RqAI) to High(RqAI) do
   begin
     if (Ind = Low(RqAI))
     then begin
        WPol := RqAI[Ind];
     end
     else begin
       WPol := WPol
            + RqAI[Ind] * Involve( ReFuncArgument(RqSeries, RqX), Ind );
     end;
   end;
 end
 else begin
  DebugErrorToReport ('LeastSquares01.CalcPolinom: '
                   +  '     '
                   +  '  ');
 end;
 CalcPolinom := WPol;
end; // of function

// ----------------------------------------------------------
//  13.10.2008.
//       BasisSelectList,
//    AI   X
function BasisCalcPolinom (RqSelectKoeff : boolean;
                           RqSeries      : word;
                           RqAI          : array of extended;
                           RqX           : extended) : extended;
var Ind       : integer;
    WPol      : extended;
    FlagBasis : boolean;
begin
 //         
 FlagBasis := False;
 if (RqSelectKoeff)
 then begin
   if Length(BasisSelectList) > 0
   then begin
     for Ind := Low(BasisSelectList) to High(BasisSelectList) do
     begin
        if (BasisSelectList[Ind] = True)
        then begin
          //  
          FlagBasis := True;
          Break;
        end;
     end;
   end;
 end;
 // ------------------------------
 if FlagBasis and (Length(RqAI) = Length(BasisSelectList))
 then begin
   //      
   WPol := 0;
   if Length(RqAI) > 0 then
   begin
     for Ind := Low(RqAI) to High(RqAI) do
     begin
       if (BasisSelectList[Ind])
       then begin
          if (Ind = Low(RqAI))
          then begin
            WPol := RqAI[Ind];
          end
          else begin
            WPol := WPol + (RqAI[Ind]
                 * Involve( ReFuncArgument(RqSeries, RqX), Ind ));
          end;
       end;
     end; // of for Ind
   end;
   BasisCalcPolinom := WPol;
 end
 else begin
   //     
   //    
   BasisCalcPolinom := CalcPolinom (RqSeries, RqAI, RqX);
 end;
end; // of function

// ==============================================================
//  UNIT,    
//     .
// ==============================================================
// --------------------------------------------------------------
// 11.10.2008
//    
function TestAndPrepare (RqSeries : word; var AproxCB : TAproxCB) : boolean;
var  Ind  :  integer;
begin
  TestAndPrepare := False;   //   
  with AproxCB do
  begin
    Abend := 0;
    if ptTabFun <> nil then
    begin
      if (Length(ptTabFun^) >= 1) then
      begin
          if (Length(ptTabFun^) - 1) >= RqExp
          then  ApExp := RqExp
          else  begin
             ApExp := Length(ptTabFun^) - 1;
             ApCod := 1;
             ApMsg := '   TabFun,   RqExp  : '
                     + IntToStr(ApExp);
          end;
          if ApExp > cLSquaresMaxRqExp then
          begin
             ApExp := cLSquaresMaxRqExp;
             ApCod := 2;
             ApMsg := ' RqExp     : '
                    + IntToStr(ApExp);
          end;
          // ---------------------------------------
          //     
          // ---------------------------------------
          //    
          SetLength(ApAi, ApExp + 1);
          for Ind := Low(ApAi) to High(ApAi) do ApAi[Ind] := 0;
          // ---------------------------------------
          //        
          TestAndPrepare := True;
          // ---------------------------------------
      end
      else begin
         Abend := 2;
         ApCod := 129;
         ApMsg := ' . TabFun    ';
         SysErrorToReport (ApMsg);
      end;
    end
    else begin
      Abend := 1;
      ApCod := 128;
      ApMsg := ' .    TabFun';
      DebugErrorToReport ('LeastSquares01.TestAndPrepare: ' + ApMsg);
    end;

  end; // with AproxCB
end; // function TestRqExp

// ==================================================================
//      
// ==================================================================
//  2.03.
// 09.12.2009
//     
//      
procedure PrepareAndExecuteGauss(RqSeries : word; var AproxCB : TAproxCB);
var  n    :  integer;  //      
var  i    :  integer;  //       
var  j    :  integer;  //       
var  Xn   :  extended;   //  X   n
var  XnJ  :  extended;   // Xn   
var  Fn   :  extended;   //      n
var  WRow :  integer;  //      
var  WCol :  integer;  //      
var  m    : integer;   //    Matrix01.AI
begin
// ----------------------
FillChar(Matrix01, SizeOF(Matrix01), #0);
with Matrix01 do
begin
  MaxRow := AproxCB.ApExp + 1;
  MaxCol := AproxCB.ApExp + 2;
  for WRow := 1 to MaxRow do
  //      
  begin
   j := WRow - 1;     //  J
   for n := Low(AproxCB.ptTabFun^) to High(AproxCB.ptTabFun^) do
   //       
   begin
      // ----------------------------------
      //      
      Xn := ReFuncArgument( RqSeries, AproxCB.ptTabFun^[n].X );
      Fn := AproxCB.ptTabFun^[n].Y;
      // ----------------------------------
      XnJ := Involve(Xn, j);  //  X   J
      for WCol := 1 To MaxCol do
      begin
         i := WCol - 1;
         if WCol = MaxCol
         then begin
            //    WRow -  
            if (n = Low(AproxCB.ptTabFun^)) or (n= High(AproxCB.ptTabFun^))
            then TAB[WRow, WCol] := TAB[WRow, WCol] + (Fn * XnJ)/2
            else TAB[WRow, WCol] := TAB[WRow, WCol] +  Fn * XnJ;
         end
         else begin
            //     WRow -  
            if (n = Low(AproxCB.ptTabFun^)) or (n= High(AproxCB.ptTabFun^))
            then TAB[WRow, WCol] := TAB[WRow, WCol] + (Involve(Xn, i)* XnJ)/2
            else TAB[WRow, WCol] := TAB[WRow, WCol] +  Involve(Xn, i)* XnJ;
         end;   
      end; // for WCol / i
   end; // for n
  end; // for WRow / j
end; // with Matrix01
// -----------------------------
if ExecGaussEquationsSet (Matrix01) then
begin
   //      AproxCB
   with AproxCB do
   begin
     i := Low(ApAi);
     for m := 1 to (ApExp + 1) do
       begin
         // -------------------------------
         //   Extended  extended
         // extended	  5.0E-324 ... 1.7E308
         // Extended	3.6E-4951 .. 1.1E4932
         //--------------------------------
         //    8 
         if Abs(Matrix01.AI[m]) > 1.0E300
         then ApAi[i] := Sign(Matrix01.AI[m]) * 1.0E300
         else ApAi[i] := Matrix01.AI[m];
         //--------------------------------
         if Abs(Matrix01.AI[m]) < 1.0E-300
         then ApAi[i] := 0;
         //--------------------------------
         Inc(i);
       end;
    end; // with AproxCB
end
else begin
   with AproxCB do
   begin
     Abend := 3;
     ApCod := 130;
     ApMsg :=    '     ,  '
      + #13#10 + '       '
      + #13#10 + '   .   .';
     SysErrorToReport (ApMsg);
   end;  
end; // if
end; // procedure
// --------------------------------------------------------------
// 11.10.2008
//  
procedure RunApprox01 (RqSeries : word; var AproxCB : TAproxCB);
begin
  if TestAndPrepare (RqSeries, AproxCB) then
  begin
    PrepareAndExecuteGauss(RqSeries, AproxCB);
  end;
end; // procedure RunApprox01

// --------------------------------------------------------------
//
//

// ==============================================================
end. // OF UNIT
